#ifndef _CRC32_CPP
#define _CRC32_CPP
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "../Headers/CRC32.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

ULONG CRCTable[256]; 

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void InitializeCRCTable(void)
{
	ULONG Polynomial = 0x04c11db7;

	// 256 Values Representing ASCII Character Codes.
	for(int Loop1 = 0; Loop1 <= 0xFF; Loop1++)
	{
		CRCTable[Loop1] = Reflect(Loop1, 8) << 24;

		for (int Loop2 = 0; Loop2 < 8; Loop2++)
			CRCTable[Loop1] = (CRCTable[Loop1] << 1) ^ (CRCTable[Loop1] & (1 << 31) ? Polynomial : 0);

		CRCTable[Loop1] = Reflect(CRCTable[Loop1], 32);
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

ULONG Reflect(ULONG Reflect, char Character)
{
	ULONG Value = 0;

	// Swap Bit 0 For Bit 7 Bit 1 For Bit 6, Etc....
	for(int Loop = 1; Loop < (Character + 1); Loop++)
	{
		if(Reflect & 1) Value |= 1 << (Character - Loop);

		Reflect >>= 1;
	}

	return Value;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD PartialCRC(ULONG InputCRC, unsigned char *Buffer, DWORD xLength)
{
	while(xLength--)
        InputCRC = (InputCRC >> 8) ^ CRCTable[(InputCRC & 0xFF) ^ *Buffer++];

	return(InputCRC);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

